/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.content;

import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMScenarioNode;
import filenet.sim.toolkit.console.VWSIMSimulationNode;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class VWSIMListViewTableModel
extends AbstractTableModel {
    public static final int COLUMN_STATUS = 0;
    public static final int COLUMN_PUBLISHED_DATA = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_NAME = 3;
    public static final int COLUMN_CUR_VERSION_AUTHOR = 4;
    public static final int COLUMN_DATE = 5;
    private static final int NUMBER_OF_COLUMN = 6;
    private static final DateFormat m_dateTimeFormatter = DateFormat.getDateTimeInstance(3, 3);
    private Vector m_rowData = null;

    public VWSIMListViewTableModel(Vector rawData) {
        this.m_rowData = rawData;
    }

    public void setData(Vector rawData) {
        this.m_rowData = rawData;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: 
            case 4: 
            case 5: {
                return String.class;
            }
            case 1: {
                return Icon.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return "";
            }
            case 2: {
                return VWSIMResource.Type;
            }
            case 3: {
                return VWSIMResource.Name;
            }
            case 1: {
                return "";
            }
            case 4: {
                return VWSIMResource.CurrentVersionAuthor;
            }
            case 5: {
                return VWSIMResource.DateModified;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        block25: {
            try {
                ImageIcon aBlkIcon = VWSIMImageLoader.createImageIcon("blank_16.gif");
                if (nRowIndex >= this.m_rowData.size()) {
                    return null;
                }
                VWSIMBaseNode aNode = (VWSIMBaseNode)this.m_rowData.elementAt(nRowIndex);
                if (aNode == null) {
                    return null;
                }
                if (aNode.getType() == 33) {
                    VWSIMScenarioNode aScnNode = (VWSIMScenarioNode)aNode;
                    switch (nColumnIndex) {
                        case 2: {
                            return new Integer(0);
                        }
                        case 3: {
                            return aScnNode.getName();
                        }
                        case 5: {
                            return m_dateTimeFormatter.format(aScnNode.getCheckinDate());
                        }
                        case 1: {
                            return aBlkIcon;
                        }
                        case 0: {
                            return new Integer(-9999);
                        }
                        case 4: {
                            return aScnNode.getCurrentVersionAuthor();
                        }
                    }
                    break block25;
                }
                if (aNode.getType() == 34) {
                    VWSIMSimulationNode aSimulationNode = (VWSIMSimulationNode)aNode;
                    ImageIcon aCheckIcon = VWSIMImageLoader.createImageIcon("check_16.gif");
                    switch (nColumnIndex) {
                        case 2: {
                            return new Integer(1);
                        }
                        case 3: {
                            String strName = aSimulationNode.getName();
                            if (strName == null) {
                                strName = "";
                            }
                            return strName;
                        }
                        case 5: {
                            Date dt = aSimulationNode.getDateCreated();
                            String strDT = "";
                            if (dt != null) {
                                strDT = m_dateTimeFormatter.format(aSimulationNode.getDateCreated());
                            }
                            return strDT;
                        }
                        case 1: {
                            if (aSimulationNode.isCollectAnalysisData()) {
                                return aCheckIcon;
                            }
                            return aBlkIcon;
                        }
                        case 0: {
                            return new Integer(aSimulationNode.getStatus());
                        }
                        case 4: {
                            return aSimulationNode.getCreator();
                        }
                    }
                    break block25;
                }
                return null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public void removeRow(int rowId) {
        this.m_rowData.removeElementAt(rowId);
        this.fireTableRowsDeleted(rowId, rowId);
    }

    public void addRow(Object obj) {
        this.m_rowData.addElement(obj);
        int rowIndex = this.m_rowData.size() - 1;
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void clearAll() {
        this.m_rowData.clear();
        this.fireTableDataChanged();
    }

    public VWSIMBaseNode getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWSIMBaseNode)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    public void releaseResources() {
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
    }
}

